﻿using System;
using System.Collections.Generic;

namespace Eliza
{
    /// <summary>
    /// A speech pattern.
    /// </summary>
    class Pattern
    {
        #region Constructor

        /// <summary>
        /// Initializes a new instance of the <see cref="Pattern"/> class.
        /// </summary>
        /// <param name="phraseToMatch">The phrase to match.</param>
        public Pattern
            (string phraseToMatch)
        {
            this.PhraseToMatch = phraseToMatch;
        }

        #endregion

        #region Properties

        /// <summary>
        /// Gets the phrase to match.
        /// </summary>
        public string PhraseToMatch {
            get;
            private set;
        }

        #endregion

        #region Public methods

        /// <summary>
        /// Checks if the pattern matches the user's input.
        /// </summary>
        /// <param name="input">The user's input.</param>
        /// <returns><see langword="true"/> if the pattern matches the user's input, otherwise <see langword="false"/>.</returns>
        public bool MatchesInput
            (string input)
        {
            // Check if the pattern's phrase was found
            return input.Contains(this.PhraseToMatch);
        }

        /// <summary>
        /// Generates a human-like response.
        /// </summary>
        /// <returns>The response.</returns>
        public string GenerateResponse()
        {
            // Create the list of possible responses
            List<string> responses = this.GetPossibleResponses();

            // Pick a random response to return
            Random random = new Random();
            int index = random.Next(responses.Count);

            // Return the response
            return responses[index];
        }

        #endregion

        #region Private methods

        /// <summary>
        /// Gets the possible responses for this pattern.
        /// </summary>
        /// <returns>The possible responses.</returns>
        private List<string> GetPossibleResponses()
        {
            List<string> responses = new List<string>();
            switch(this.PhraseToMatch) {
                case "BECAUSE":
                    responses.Add("IS THAT THE REAL REASON?");
                    responses.Add("DON'T ANY OTHER REASONS COME TO MIND?");
                    responses.Add("DOES THAT REASON SEEM TO EXPLAIN ANYTHING ELSE?");
                    responses.Add("WHAT OTHER REASONS MIGHT THERE BE?");
                    break;

                case "YES":
                    responses.Add("YOU SEEM QUITE POSITIVE.");
                    responses.Add("ARE YOU SURE?");
                    responses.Add("I SEE.");
                    responses.Add("OK.");
                    break;

                case "NO":
                    responses.Add("YOU'RE BEING A BIT NEGATIVE.");
                    responses.Add("ARE YOU SAYING NO JUST TO BE NEGATIVE?");
                    responses.Add("WHY NOT?");
                    break;
            }

            // Return the possible responses
            return responses;
        }

        #endregion
    }
}
